#include <allegro.h>
#ifndef NO_GL
#include <alleggl.h>
#include <GL/glu.h>
#endif
#include <math.h>

#include "main.h"
#include "draw.h"
#include "game.h"

#include "actor.h"
#include "sectors.h"

#include "man.h"
#include "shot.h"
#include "F18.h"
#include "tree.h"
#include "alienship.h"
#include "mothership.h"
#include "station.h"
#include "number.h"
#include "gameover.h"
#include "sfx.h"
#include "population.h"
#include "shield.h"
#include "ammo.h"
#include "midi.h"
#include "peace.h"
#include "pullup.h"
#include "tower.h"
#include "credits.h"
#include "fir.h"
#include "letters.h"

int population;
int shield;
int ammo;

static int uptime;
static int blinktime;

static int done;

RGB skycol = {0, 0, 0};

static void mline(BITMAP *bm, int x1, int y1, int x2, int y2, int c)
{
#ifndef NO_GL
	int r = c >> 5;
	int g = (c >> 2) & 7;
	int b = c & 3;
	r = r * 255 / 7;
	g = g * 255 / 7;
	b = b * 255 / 3;
	
	glBegin(GL_LINES);
	glColor3ub(r, g, b);
	glVertex3f(x1, y1, 0);
	glVertex3f(x2, y2, 0);
	glEnd();	
#else
	line(bm, x1, y1, x2, y2, c);
#endif
}

#define STARCOUNT 100
float starx[STARCOUNT];
float stary[STARCOUNT];
int starcol[STARCOUNT];

void game_init(void)
{
	ACTOR *actor;
	
	if (sound_on) play_midi(&holst_midi, 1);
	
	uptime = 0;
	blinktime = 0;
	
	done = 0;
	
	{
		int i;
		for (i = 0; i < STARCOUNT; i++) {
			starx[i] = alienship.x + ((rand() & 2047) - 1024) ;
			stary[i] = alienship.y + ((rand() & 511) - 256) ;
		}
	}
	
	sectors_init();
	mans_total = 0;
	mans_num = 0;
	shots_num = 0;

	population = 0;
	ammo = 1000;
	{
		int x;
		for (x = 0; x < SECTORS * SECTOR_DIMENSION; x += 64) {
			int r = (rand() >> 8) & 15;
			if (r == 1) {
				if (x < SECTORS * SECTOR_DIMENSION * 1 / 3 ||
					x > SECTORS * SECTOR_DIMENSION * 2 / 3) actor = tree_init();
				else
					actor = fir_init();
			} else if (r == 2) {
				actor = F18_init();
				actor->y = 300 + (rand() & 511);
			} else if (r == 3) {
				actor = tower_init();
				population += 99;
			} else {
				actor = man_init();
				population++;
			}
			if (actor) {
				actor->x = x;
				sector_place_man(actor);
			}
		}
	}

#ifndef NO_GL	
		skycol.r = 53;
		skycol.g = 53;
		skycol.b = 63;
#else
	{
		RGB rgb = {53, 53, 63};
		set_color(255, &rgb);
	}
#endif

	number_init();
	number_init();
	number_init();
	number_init();
	
	actor = alienship_init();
	actor->x = 1000;
	actor->y = 9250;
	actor = mothership_init();
	actor->x = 1000;
	actor->y = 10000;
	actor = station_init();
	actor->x = 1000;
	actor->y = 9000;
	
}

void game_input(void)
{
	
	if (population <= 0) {
		if (!done) credits_init();
		done++;
		if (done > FPS * 5) credits_input();
		return;
	}
	
	{
		int i = rand() % STARCOUNT;
		starx[i] = alienship.x + ((rand() & 2047) - 1024);
		stary[i] = alienship.y + ((rand() & 511) - 256);
	}
	
	shield = alienship.health / 10;
	
	actors_process();
}

void game_render(void)
{
	static float fx = 0, fy = 0;
	int sx = 0, sy = 0;
	int y = (alienship.y - 500) / 200;
	
	if (done) {
		if (done < FPS * 5) {
			letters_draw(SCREEN_W / 3, SCREEN_H / 2 - 15, 3, "PEACE AGAIN AT LAST", "PEACE AGAIN AT LAST", 0);
			letters_draw(SCREEN_W / 3, SCREEN_H / 2 + 15, 3, "  CONGRATULATIONS", "  CONGRATULATIONS", 0);
		} else {
			credits_render();
		}
		return;
	}
	
	if (fx < alienship.dx * 5) fx++;
	if (fx > alienship.dx * 5) fx--;
	if (fy < alienship.dy * 4) fy++;
	if (fy > alienship.dy * 4) fy--;
	
	sx = alienship.x + fx;
	sy = alienship.y + fy;

	if (y >= 0 && y <= 63) {
		RGB rgb;
		int r = 53 - y;
		int g = 53 - y;
		int b = 63 - y;
		if (r < 0) r = 0;
		if (g < 0) g = 0;
		if (b < 0) b = 0;
		rgb.r = r;
		rgb.g = g;
		rgb.b = b;
#ifndef NO_GL
		skycol.r = r;
		skycol.g = g;
		skycol.b = b;
#else
		set_color(255, &rgb);
#endif	
}
#ifndef NO_GL	
	glBegin(GL_QUADS);
	glColor3ub((skycol.r) * 4, (skycol.g) * 4, (skycol.b) * 4);
	glVertex3f(SCREEN_W, 0, 0);
	glVertex3f(0, 0, 0);
	glVertex3f(0,  SCREEN_H / 2 + sy, 0);
	glVertex3f(SCREEN_W,  SCREEN_H / 2 + sy, 0);
	glEnd();
	
	glBegin(GL_QUADS);
	glColor3ub(0, 0, 0);
	glVertex3f(SCREEN_W, SCREEN_H / 2 + sy, 0);
	glVertex3f(0, SCREEN_H / 2 + sy, 0);
	glVertex3f(0,  SCREEN_H, 0);
	glVertex3f(SCREEN_W,  SCREEN_H, 0);
	glEnd();
		
	{
		GLUquadricObj* qo = gluNewQuadric();
		glPushMatrix();
		glTranslatef(SCREEN_W / 2 + 1000 - sx,	SCREEN_H / 2 + sy - 9250, 0);
		glColor3ub(255, 255, 200);
		gluDisk(qo, 0, 200, 31, 1);
		glPopMatrix();
	}
		
#else
	rectfill(page, 0, 0, SCREEN_W - 1, SCREEN_H / 2 + sy - 1,
		255);
	rectfill(page, 0, SCREEN_H / 2 + sy, SCREEN_W - 1,
		SCREEN_H - 1, 0);
		
	circlefill(page, SCREEN_W / 2 + 1000 - sx,
		SCREEN_H / 2 + sy - 9250, 200, 254);
#endif

	if (y > 48) {
		int i;
#ifndef NO_GL	
		glColor3ub(255, 255, 0);
		glPointSize(3);
		glBegin(GL_POINTS);
		for (i = 0; i < STARCOUNT; i++) {
			if (stary[i] > 10100 + SCREEN_H) {
				glVertex3f(starx[i] - alienship.x, -stary[i] + alienship.y, 0);
			}
		}
		glEnd();
#else
		for (i = 0; i < STARCOUNT; i++) {
			if (stary[i] > 10100 + SCREEN_H) {
				circle(page, starx[i] - alienship.x, -stary[i] + alienship.y, 2, 
					4 * 7 + 32 * 7);
			}
		}
#endif	
	}

	actors_draw(sx, sy);
	
	if (alienship.health <= 0)
		gameover_draw(SCREEN_W / 2, SCREEN_H / 2);
	
	{
		float dx, dy, d;
		dx = station.x - alienship.x;
		if (dx > SECTORS * SECTOR_DIMENSION / 2) dx -= SECTORS * SECTOR_DIMENSION;
		if (dx < -SECTORS * SECTOR_DIMENSION / 2) dx += SECTORS * SECTOR_DIMENSION;
		dy = station.y - alienship.y;
		d = sqrt(dx * dx + dy * dy);
		
		{
			int m;
			for (m = 0; m < mans_num; m++) {
				float dx = man[m]->x - alienship.x;
				int dy = (man[m]->y - alienship.y) / 150;
				if (dx > SECTORS * SECTOR_DIMENSION / 2) {
					dx -= SECTORS * SECTOR_DIMENSION;
				}
				if (dx < -SECTORS * SECTOR_DIMENSION / 2) {
					dx += SECTORS * SECTOR_DIMENSION;
				}
				dx /= 150;
				if (man[m]->hit == 0 && dx > -30 && dx < 30 && dx > -30 && dx < 30) {
					mline(page, 40 + dx, SCREEN_H - 30 - dy, 41 + dx, SCREEN_H - 30 - dy,
						7 * 32);
				}
			}
		}	
		
		mline(page,
			40            +  5 * dy / d,
			SCREEN_H - 30 +  5 * dx / d,
			40            + 30 * dx / d,
			SCREEN_H - 30 - 30 * dy / d,
			7 * 8);
		mline(page,
			40            -  5 * dy / d,
			SCREEN_H - 30 -  5 * dx / d,
			40            + 30 * dx / d,
			SCREEN_H - 30 - 30 * dy / d,
			7 * 8);
		mline(page,
			40            +  5 * dy / d,
			SCREEN_H - 30 +  5 * dx / d,
			40            -  5 * dy / d,
			SCREEN_H - 30 -  5 * dx / d,
			7 * 8);
			
			
		{
			int s;
			for (s = 0; s < SECTORS; s++) {
				mline(page,
					5 + 70 * s / SECTORS, SCREEN_H - 5, 6 + 70 * s / SECTORS, SCREEN_H - 5,
					sector_mans_num[s] > 0 ? 7 * 32 : 7 * 8);
			}
		}
			
		mline(page,
			5 + alienship.x * 70 / (SECTORS * SECTOR_DIMENSION), SCREEN_H - 8,
			5 + alienship.x * 70 / (SECTORS * SECTOR_DIMENSION), SCREEN_H - 2,
			7 * 8);
			
		mline(page,
			SCREEN_W - 7, SCREEN_H - 5 - 800 * (SCREEN_H - 30) / 10000,
			SCREEN_W - 3, SCREEN_H - 5 - 800 * (SCREEN_H - 30) / 10000,
			4 * 4);
			
			
		mline(page,
			SCREEN_W - 5,
			SCREEN_H - 5,
			SCREEN_W - 5,
			SCREEN_H - 5 - MIN(10000, alienship.y) * (SCREEN_H - 30) / 10000,
			32 * 3);
	}
	
	population_draw(80, 60);
	ammo_draw(SCREEN_W - 80, 60);
	shield_draw(SCREEN_W / 2, 60);
		
	if (alienship.y > 2000) {
		uptime++;
		if (uptime > FPS * 5) {
			blinktime = FPS * 2;
			uptime = 0;
		}
	} else if (alienship.y > 400) {
		if (alienship.y + alienship.dy * FPS * 2 < 0) {
			pullup_draw(SCREEN_W / 2, SCREEN_H / 2);
		}
	}
	if (blinktime || alienship.y > 10000) {
		peace_draw(SCREEN_W / 2, SCREEN_H / 2);
		uptime = 0;
		if (blinktime) blinktime--;
	}

}
